# Określanie częstotliwości występowania liter:
# https://www.nostarch.com/crackingcodes (na licencji BSD).

ETAOIN = 'ETAOINSHRDLCUMWFGYPBVKJXQZ'
LETTERS = 'ABCDEFGHIJKLMNOPQRSTUVWXYZ'

def getLetterCount(message):
    # Zwraca słownik, którego klucze to pojedyncze wielkie litery, wartości zaś to liczby
    # całkowite określające liczbę wystąpień poszczególnych liter w parametrze message.
    letterCount = {'A': 0, 'B': 0, 'C': 0, 'D': 0, 'E': 0, 'F': 0, 'G': 0, 'H': 0, 'I': 0, 'J': 0, 'K': 0, 'L': 0, 'M': 0, 'N': 0, 'O': 0, 'P': 0, 'Q': 0, 'R': 0, 'S': 0, 'T': 0, 'U': 0, 'V': 0, 'W': 0, 'X': 0, 'Y': 0, 'Z': 0}

    for letter in message.upper():
        if letter in LETTERS:
            letterCount[letter] += 1

    return letterCount


def getItemAtIndexZero(items):
    return items[0]


def getFrequencyOrder(message):
    # Zwraca ciąg tekstowy liter alfabetu ułożonych w kolejności
    # od najczęściej występującej w parametrze message.

    # Po pierwsze, trzeba pobrać słownik poszczególnych liter i częstotliwości ich występowania.
    letterToFreq = getLetterCount(message)

    # Po drugie, trzeba utworzyć słownik poszczególnych częstotliwości występowania
    # i listy liter występujących daną liczbę razy.
    freqToLetter = {}
    for letter in LETTERS:
        if letterToFreq[letter] not in freqToLetter:
            freqToLetter[letterToFreq[letter]] = [letter]
        else:
            freqToLetter[letterToFreq[letter]].append(letter)

    # Po trzecie, każdą listę liter trzeba posortować w odwrotnej kolejności "EATOIN",
    # a następnie skonwertować na ciąg tekstowy.
    for freq in freqToLetter:
        freqToLetter[freq].sort(key=ETAOIN.find, reverse=True)
        freqToLetter[freq] = ''.join(freqToLetter[freq])

    # Po czwarte, trzeba skonwertować słownik freqToLetter na listę 
    # par krotek (klucz, wartość), a następnie je posortować.
    freqPairs = list(freqToLetter.items())
    freqPairs.sort(key=getItemAtIndexZero, reverse=True)

    # Po piąte, gdy litery są ułożone według częstotliwości występowania,
    # należy wyodrębnić wszystkie litery dla ostatecznego ciągu tekstowego.
    freqOrder = []
    for freqPair in freqPairs:
        freqOrder.append(freqPair[1])

    return ''.join(freqOrder)


def englishFreqMatchScore(message):
    # Zwraca liczbę dopasowań, które ma ciąg tekstowy w parametrze message, gdy
    # częstotliwość występowania w nim liter jest porównywana z częstotliwością
    # występowania liter w tekście angielskim. "Dopasowanie" określa, ile z sześciu
    # najczęściej i sześciu najrzadziej występujących liter znajduje się wśród sześciu
    # najczęściej i sześciu najrzadziej występujących liter w języku angielskim.

    freqOrder = getFrequencyOrder(message)

    matchScore = 0
    # Ustala liczbę dopasowań dla sześciu najczęściej występujących liter.
    for commonLetter in ETAOIN[:6]:
        if commonLetter in freqOrder[:6]:
            matchScore += 1
    # Ustala liczbę dopasowań dla sześciu najrzadziej występujących liter.
    for uncommonLetter in ETAOIN[-6:]:
        if uncommonLetter in freqOrder[-6:]:
            matchScore += 1

    return matchScore
